% Beispiel: Impuls- und Sprungantwort im z-Bereich (Signal Processing Toolbox)
% T.Fischer, 27.02.2014

clear all
close all
clc

Ordnung = 8;
T0 = 1;  % Abtastzeit [sec]
TEnd = T0*50;  % Simulationsdauer [sec]
                              %                          z
Giir = tf([0.5 0.5],[1 -0.6],T0) % bertragungsfunktion:  -------
                              %                        z - 0.82    
                              
% Ausrechnen des Nenners fr FIR 8. Ordnung:
Nenner = zeros(1,Ordnung+1);
Nenner(1) = 0.5;
for ord=2:Ordnung+1
    Nenner(ord) = 0.8*0.6^(ord-2);
end
          
Zaehler = zeros(1,Ordnung+1);
Zaehler(1) = 1;
                              %                          0.9
Gfir = tf(Nenner,Zaehler,T0) % bertragungsfunktion:  -------
                              %                        z - 0.82 
                              
[hiir,k] = step(Giir,TEnd);           % Sprungantwort des Systems
[giir] = impulse(Giir,TEnd);           % Sprungantwort des Systems

[hfir] = step(Gfir,TEnd);           % Sprungantwort des Systems
[gfir] = impulse(Gfir,TEnd);           % Sprungantwort des Systems

%%%%%%%%%%%%%%%
% Darstellung %
%%%%%%%%%%%%%%%

schrift = 12;

figure(1)
set(gcf,'position',[50 50 1000 500])
subplot(1,2,1)
hold on
plot(k,hiir,'r.-')
plot(k,hfir,'k.-')
title('Sprungantwort','fontsize',schrift)
xlabel('t [s]','fontsize',schrift)
ylabel('hiir, hfir','fontsize',schrift,'rotation',90)
legend('Giir','Gfir')
set(gca,'fontsize',schrift,'linewidth',1.5)
hold off

figure(1)
subplot(1,2,2)
hold on
plot(k,giir,'r.-')
plot(k,gfir,'k.-')
title('Impulsantwort','fontsize',schrift)
xlabel('t [s]','fontsize',schrift)
ylabel('giir(t), gfir','fontsize',schrift,'rotation',90)
legend('Giir','Gfir')
set(gca,'fontsize',schrift,'linewidth',1.5)
hold off